///////////////////////////////////////////////////
//
//	FILE:       MG87E(L)6051_IAP_Sample_for_C.c
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	PURPOSE:    Demo IAP Function
//
///////////////////////////////////////////////////
typedef struct IAP_Addr
{  unsigned char Low ;
   unsigned char High ;
};

#define     AP_End_Addr       0x017FF
#define     IAP_Start_Addr    0x01800
#define     IAP_End_Addr      0x01BFF
#define     Xtal_Freq         12              // Unit:MHz

#include    "REG_MG87FL2051-6051.H"

void Set_IAP_Space (void) ;
void IAP_Erase_512B (void) ;
void IAP_Write_512B (void) ;
void IAP_Blank_Check (unsigned int) ;
void IAP_Read_Check_512B (void) ;
void IAP_Page_Erase (unsigned int,unsigned char) ;
unsigned char IAP_Read_Byte (unsigned int,unsigned char) ;
unsigned char Read_IAPLB (unsigned char) ;
void Write_IAPLB (unsigned char,unsigned char) ;
void IAP_Write_Byte (unsigned int, unsigned char,unsigned char) ;
void IAP_Fail (void) ;

unsigned char Trigger_Check1=0x55;

///////////////////////////////////////////////////
//
//    MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{  
   P1 = 0xff;                                   //Turn off all LED

   Set_IAP_Space() ;

   IAP_Erase_512B() ;

   IAP_Write_512B() ;

   IAP_Read_Check_512B() ;

   P1=0xF7 ;                                    //Turn on all LED

	while (1) {}
}

///////////////////////////////////////////////////
//
//    Function:Set_IAP_Space
//
///////////////////////////////////////////////////
void Set_IAP_Space (void)
{  Write_IAPLB(IAP_Start_Addr>>8,0xAA) ;
   if (Read_IAPLB(0xAA) != IAP_Start_Addr >> 8)
     IAP_Fail() ;     
}

///////////////////////////////////////////////////
//
//    Function:Erase
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Erase_512B (void)
{   IAP_Page_Erase(IAP_Start_Addr,0xAA) ;
    IAP_Blank_Check(IAP_Start_Addr) ;    
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Blank_Check()
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Blank_Check(unsigned int IAP_Addr)
{  unsigned int IAP_Addr_Up_Bundary=IAP_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
   {  if ( 0xFF != IAP_Read_Byte(IAP_Addr,0xAA))
         IAP_Fail() ;
   }
}

///////////////////////////////////////////////////
//
//    Function:Read 512Byte
//
///////////////////////////////////////////////////
void IAP_Read_Check_512B (void)
{  unsigned int IAP_Addr=IAP_Start_Addr;
   unsigned int IAP_Addr_Up_Bundary=IAP_Start_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
   {  unsigned char x = ((IAP_Addr>>8)+(IAP_Addr & 0xFF)) ;
      unsigned char y = IAP_Read_Byte(IAP_Addr,0xAA) ;
      if (x != y)
         IAP_Fail() ;     
   }
}

///////////////////////////////////////////////////
//
//    Function:Write 512Byte
//
///////////////////////////////////////////////////
void IAP_Write_512B (void)
{  unsigned int IAP_Addr=IAP_Start_Addr;
   unsigned int IAP_Addr_Up_Bundary=IAP_Start_Addr+0x0200 ;
   for(;IAP_Addr<IAP_Addr_Up_Bundary;IAP_Addr++)
      IAP_Write_Byte(IAP_Addr,((IAP_Addr>>8)+(IAP_Addr & 0xFF)),0xAA) ;
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Page_Erase ( Address , 0xAA ) ;
//    Erase One page (512 bytes)
//
///////////////////////////////////////////////////
void IAP_Page_Erase(unsigned int IAP_Addr,unsigned char Trigger_Check2)
{
   CKCON2 = CKCON2 & 0xC0 ;
   CKCON2 = CKCON2 | (Xtal_Freq-1 & 0x3F) ;  
   ISPCR = ISPCR | 0x80 ;       
   IFADRH = IAP_Addr >> 8 ;                     //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF ;                   //IAP Flash Address Low Byte
   IFMT = 0x03 ;                                //IAP Flash Mode Table (Erase Mode)

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00;
   ISPCR = ISPCR & 0x7F ;
}

///////////////////////////////////////////////////
//
//	   Function:x = IAP_Read_Byte(Address , 0xAA) ;
//    Read one byte from IAP address
//
///////////////////////////////////////////////////
unsigned char IAP_Read_Byte(unsigned int IAP_Addr,unsigned char Trigger_Check2)
{
   CKCON2 = CKCON2 & 0xC0 ;
   CKCON2 = CKCON2 | (Xtal_Freq-1 & 0x3F) ; 
   ISPCR = ISPCR | 0x80 ;   
   IFADRH = IAP_Addr >> 8 ;                     //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF ;                   //IAP Flash Address Low Byte
   IFMT = 0x01 ;                                //IAP Flash Mode Table (Read Mode)
   IFD = 0x00 ;

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00;
   ISPCR = ISPCR & 0x7F ;
   return(IFD);                                 //Return Flash data                                                  
}

///////////////////////////////////////////////////
//
//	   Function:x = IAP_Read_Byte(0xAA) ;
//    Read one byte from IAP address
//
///////////////////////////////////////////////////
unsigned char Read_IAPLB(unsigned char Trigger_Check2)
{
   CKCON2 = CKCON2 & 0xC0 ;
   CKCON2 = CKCON2 | (Xtal_Freq-1 & 0x3F) ;   
   ISPCR = ISPCR | 0x80 ;   
   IFMT = 0x05 ;                                //IAP Flash Mode Table (Read Mode)
   IFADRH = 0x00 ;                              //IAP Flash Address High Byte
   IFADRL = 0x00 ;                              //IAP Flash Address Low Byte
   IFD = 0x00 ;

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00;
   ISPCR = ISPCR & 0x7F ;
   return(IFD);                                 //Return Flash data                                                  
}

///////////////////////////////////////////////////
//
//	   Function:Write_IAPLB (Address High Byte , 0xAA) ;
//    Write to IAP address one byte
//
///////////////////////////////////////////////////
void Write_IAPLB(unsigned char IAPLBHB,unsigned char Trigger_Check2)
{
   CKCON2 = CKCON2 & 0xC0 ;
   CKCON2 = CKCON2 | (Xtal_Freq-1 & 0x3F) ; 
   ISPCR = ISPCR | 0x80 ;   
   IFMT = 0x04 ;                                //IAP Flash Mode Table (Write Mode)
   IFADRH = 0xFF;                               //IAP Flash Address High Byte
   IFADRL = 0xFF;                               //IAP Flash Address Low Byte
   IFD = IAPLBHB ;                              //Flash data buffer

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00; 
   ISPCR = ISPCR & 0x7F ;
}

///////////////////////////////////////////////////
//
//	   Function:IAP_Write_Byte(Address , Data , 0xAA) ;
//    Write to IAP address one byte
//
///////////////////////////////////////////////////
void IAP_Write_Byte(unsigned int IAP_Addr, unsigned char Value,unsigned char Trigger_Check2)
{
   CKCON2 = CKCON2 & 0xC0 ;
   CKCON2 = CKCON2 | (Xtal_Freq-1 & 0x3F) ; 
   ISPCR = ISPCR | 0x80 ;   
   IFADRH = IAP_Addr >> 8;                      //IAP Flash Address High Byte
   IFADRL = IAP_Addr & 0xFF;                    //IAP Flash Address Low Byte
   IFD = Value ;                                //Flash data buffer
   IFMT = 0x02 ;                                //IAP Flash Mode Table (Write Mode)

   if (Trigger_Check1==0x55)
      SCMD = 0x46 ;
   else
      IAP_Fail() ;

   if (Trigger_Check2==0xAA)
   {  SCMD = 0xB9 ;     
   }
   else
   {  SCMD = 0x00 ;
      IAP_Fail() ;
   }
   Trigger_Check2=0x00; 
   ISPCR = ISPCR & 0x7F ;
}

///////////////////////////////////////////////////
//
//    IAP_Fail()
//
///////////////////////////////////////////////////
void IAP_Fail(void)
{  P1=0xFB ;
   while(1) ;
}
